#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "map.h"
#include "gmstuff.h"
#include "switchstuff.h"
#include "linkstuff.h"

char *Mapfile;
char *Switchfile;
char *Wirelist;
int Hport;               /* Host port ID to test links from */
int Test_all_hports;      /* boolean, test out of all host ports if true */
extern int Test_kbytes;
extern int Test_id_pkts;
extern double BWthresh;
extern int My_host_id;
char *Test_x1;
int Test_p1;
char *Test_x2;
int Test_p2;
char __b1[100], __b2[100];

void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Wirelist = NULL;
  Test_kbytes = 4096;
  BWthresh = 0.;
  Test_x1 = NULL;
  Test_all_hports = 1;

  while ((c = getopt(argc, argv, "i:m:s:w:l:t:I:")) != EOF) switch (c) {

  case 'm':	/* map file (input) */
    Mapfile = optarg;
    break;

  case 's':	/* switch file (input) */
    Switchfile = optarg;
    break;

  case 'w':	/* wiring list file (input) */
    Wirelist = optarg;
    break;

  case 'i':  /* Host port Id to test out of */
    Hport = atoi(optarg);
		Test_all_hports = 0;
    break;

  case 'I':     /* use ID packets (assumes xbar32's) */
    Test_id_pkts = atoi(optarg);
    assert(Test_id_pkts > 0);
    break;

  case 'l':
    Test_kbytes = atoi(optarg);
    break;

  case 't':
    {
      char *pp;

      Test_x1 = __b1;
      Test_x2 = __b2;
      pp = index(optarg,':');
      assert(pp != NULL);
      *pp = 0;
      strcpy(Test_x1, optarg);
      Test_p1 = atoi(pp+1);
      pp = index(pp+1, '/');
      assert(pp != NULL);
      optarg = pp+1;

      pp = index(optarg,':');
      assert(pp != NULL);
      *pp = 0;
      strcpy(Test_x2, optarg);
      Test_p2 = atoi(pp+1);
    }
    printf("Testing %s:%d <-> %s:%d\n", Test_x1, Test_p1, Test_x2, Test_p2);
    break;

  }

  if (Mapfile == NULL) {
    fprintf(stderr, "Map file is required!\n");
    exit(1);
  }
}

int
main(
  int argc,
  char **argv)
{
  struct mapfile mf;

  parse_args(argc, argv);

  mf.name = Mapfile;

  initialize_gm();   

  load_map_file(&mf);     
  find_self(&mf);

	/* If user asked to test out of a single port instead of all ports,
	 * make sure that port exists according to the map.
	 */
	if (! Test_all_hports) {
		if (Hport >= mf.host[My_host_id].nport) {
    	fprintf(stderr, "Requested host port number too big\n");
	    exit(1);
		}
	}

  calc_xbar_routes(&mf);  /* calculate routes to all xbars */ 

  if (Test_all_hports) {
    for (Hport = 0; Hport < mf.host[My_host_id].nport; Hport++) {
  		check_all_links(&mf);
		}
	} else {
			/* Just do checking out of whatever port Hport is set to */
  		check_all_links(&mf);
	}

  close_gm();

  return 0;
}   
